package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link VsphereVirtualDiskVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVsphereVirtualDiskVolumeSourceAssert<S extends AbstractVsphereVirtualDiskVolumeSourceAssert<S, A>, A extends VsphereVirtualDiskVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVsphereVirtualDiskVolumeSourceAssert}</code> to make assertions on actual VsphereVirtualDiskVolumeSource.
   * @param actual the VsphereVirtualDiskVolumeSource we want to make assertions on.
   */
  protected AbstractVsphereVirtualDiskVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VsphereVirtualDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual VsphereVirtualDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property volumePath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumePath()  {
    // check that actual VsphereVirtualDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumePath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumePath"));
  }


}
