package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link RollingDeploymentStrategyParams} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRollingDeploymentStrategyParamsAssert<S extends AbstractRollingDeploymentStrategyParamsAssert<S, A>, A extends RollingDeploymentStrategyParams> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRollingDeploymentStrategyParamsAssert}</code> to make assertions on actual RollingDeploymentStrategyParams.
   * @param actual the RollingDeploymentStrategyParams we want to make assertions on.
   */
  protected AbstractRollingDeploymentStrategyParamsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual RollingDeploymentStrategyParams's intervalSeconds is equal to the given one.
   * @param intervalSeconds the given intervalSeconds to compare the actual RollingDeploymentStrategyParams's intervalSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingDeploymentStrategyParams's intervalSeconds is not equal to the given one.
   */
  public S hasIntervalSeconds(Long intervalSeconds) {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting intervalSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualIntervalSeconds = actual.getIntervalSeconds();
    if (!Objects.areEqual(actualIntervalSeconds, intervalSeconds)) {
      failWithMessage(assertjErrorMessage, actual, intervalSeconds, actualIntervalSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property maxSurge so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.IntOrStringAssert maxSurge()  {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.IntOrStringAssert) assertThat(actual.getMaxSurge()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "maxSurge"));
  }


  /**
   * Navigates to the property maxUnavailable so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.IntOrStringAssert maxUnavailable()  {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.IntOrStringAssert) assertThat(actual.getMaxUnavailable()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "maxUnavailable"));
  }


  /**
   * Navigates to the property post so that assertions can be done on it
   */
  public LifecycleHookAssert post()  {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LifecycleHookAssert) assertThat(actual.getPost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "post"));
  }


  /**
   * Navigates to the property pre so that assertions can be done on it
   */
  public LifecycleHookAssert pre()  {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LifecycleHookAssert) assertThat(actual.getPre()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pre"));
  }


  /**
   * Verifies that the actual RollingDeploymentStrategyParams's timeoutSeconds is equal to the given one.
   * @param timeoutSeconds the given timeoutSeconds to compare the actual RollingDeploymentStrategyParams's timeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingDeploymentStrategyParams's timeoutSeconds is not equal to the given one.
   */
  public S hasTimeoutSeconds(Long timeoutSeconds) {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualTimeoutSeconds = actual.getTimeoutSeconds();
    if (!Objects.areEqual(actualTimeoutSeconds, timeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, timeoutSeconds, actualTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RollingDeploymentStrategyParams's updatePercent is equal to the given one.
   * @param updatePercent the given updatePercent to compare the actual RollingDeploymentStrategyParams's updatePercent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingDeploymentStrategyParams's updatePercent is not equal to the given one.
   */
  public S hasUpdatePercent(Integer updatePercent) {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updatePercent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualUpdatePercent = actual.getUpdatePercent();
    if (!Objects.areEqual(actualUpdatePercent, updatePercent)) {
      failWithMessage(assertjErrorMessage, actual, updatePercent, actualUpdatePercent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RollingDeploymentStrategyParams's updatePeriodSeconds is equal to the given one.
   * @param updatePeriodSeconds the given updatePeriodSeconds to compare the actual RollingDeploymentStrategyParams's updatePeriodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingDeploymentStrategyParams's updatePeriodSeconds is not equal to the given one.
   */
  public S hasUpdatePeriodSeconds(Long updatePeriodSeconds) {
    // check that actual RollingDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updatePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualUpdatePeriodSeconds = actual.getUpdatePeriodSeconds();
    if (!Objects.areEqual(actualUpdatePeriodSeconds, updatePeriodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, updatePeriodSeconds, actualUpdatePeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
