package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link OAuthAuthorizeToken} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOAuthAuthorizeTokenAssert<S extends AbstractOAuthAuthorizeTokenAssert<S, A>, A extends OAuthAuthorizeToken> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOAuthAuthorizeTokenAssert}</code> to make assertions on actual OAuthAuthorizeToken.
   * @param actual the OAuthAuthorizeToken we want to make assertions on.
   */
  protected AbstractOAuthAuthorizeTokenAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property clientName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clientName()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClientName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clientName"));
  }


  /**
   * Verifies that the actual OAuthAuthorizeToken's expiresIn is equal to the given one.
   * @param expiresIn the given expiresIn to compare the actual OAuthAuthorizeToken's expiresIn to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthAuthorizeToken's expiresIn is not equal to the given one.
   */
  public S hasExpiresIn(Long expiresIn) {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting expiresIn of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualExpiresIn = actual.getExpiresIn();
    if (!Objects.areEqual(actualExpiresIn, expiresIn)) {
      failWithMessage(assertjErrorMessage, actual, expiresIn, actualExpiresIn);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property redirectURI so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert redirectURI()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRedirectURI()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "redirectURI"));
  }


  /**
   * Navigates to the property scopes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> scopes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getScopes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scopes"));
    return answer;
  }


  /**
   * Navigates to the property state so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert state()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "state"));
  }


  /**
   * Navigates to the property userName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert userName()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUserName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userName"));
  }


  /**
   * Navigates to the property userUID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert userUID()  {
    // check that actual OAuthAuthorizeToken we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUserUID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userUID"));
  }


}
