package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PersistentVolumeClaimSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeClaimSpecFluentAssert<S extends AbstractPersistentVolumeClaimSpecFluentAssert<S, A>, A extends PersistentVolumeClaimSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeClaimSpecFluentAssert}</code> to make assertions on actual PersistentVolumeClaimSpecFluent.
   * @param actual the PersistentVolumeClaimSpecFluent we want to make assertions on.
   */
  protected AbstractPersistentVolumeClaimSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PersistentVolumeClaimSpecFluent's accessModes contains the given String elements.
   * @param accessModes the given elements that should be contained in actual PersistentVolumeClaimSpecFluent's accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeClaimSpecFluent's accessModes does not contain all given String elements.
   */
  public S hasAccessModes(String... accessModes) {
    // check that actual PersistentVolumeClaimSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (accessModes == null) throw new AssertionError("Expecting accessModes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAccessModes(), accessModes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimSpecFluent has no accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeClaimSpecFluent's accessModes is not empty.
   */
  public S hasNoAccessModes() {
    // check that actual PersistentVolumeClaimSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have accessModes but had :\n  <%s>";
    
    // check
    if (actual.getAccessModes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAccessModes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PersistentVolumeClaimSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PersistentVolumeClaimSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PersistentVolumeClaimSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimSpecFluent's resources is equal to the given one.
   * @param resources the given resources to compare the actual PersistentVolumeClaimSpecFluent's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimSpecFluent's resources is not equal to the given one.
   */
  public S hasResources(ResourceRequirements resources) {
    // check that actual PersistentVolumeClaimSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ResourceRequirements actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeClaimSpecFluent's volumeName is equal to the given one.
   * @param volumeName the given volumeName to compare the actual PersistentVolumeClaimSpecFluent's volumeName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeClaimSpecFluent's volumeName is not equal to the given one.
   */
  public S hasVolumeName(String volumeName) {
    // check that actual PersistentVolumeClaimSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected volumeName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualVolumeName = actual.getVolumeName();
    if (!Objects.areEqual(actualVolumeName, volumeName)) {
      failWithMessage(assertjErrorMessage, actual, volumeName, actualVolumeName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
