package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;

/**
 * Abstract base class for {@link KubernetesResourceList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesResourceListAssert<S extends AbstractKubernetesResourceListAssert<S, A>, A extends KubernetesResourceList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesResourceListAssert}</code> to make assertions on actual KubernetesResourceList.
   * @param actual the KubernetesResourceList we want to make assertions on.
   */
  protected AbstractKubernetesResourceListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubernetesResourceList's items contains the given HasMetadata elements.
   * @param items the given elements that should be contained in actual KubernetesResourceList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesResourceList's items does not contain all given HasMetadata elements.
   */
  public S hasItems(HasMetadata... items) {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // check that given HasMetadata varargs is not null.
    if (items == null) throw new AssertionError("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubernetesResourceList has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual KubernetesResourceList's items is not empty.
   */
  public S hasNoItems() {
    // check that actual KubernetesResourceList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
