/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ScopeRestriction;
import io.fabric8.openshift.api.model.ScopeRestrictionFluent;
import io.fabric8.openshift.api.model.ScopeRestrictionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ScopeRestrictionBuilder
extends ScopeRestrictionFluentImpl<ScopeRestrictionBuilder>
implements VisitableBuilder<ScopeRestriction, ScopeRestrictionBuilder> {
    ScopeRestrictionFluent<?> fluent;
    Boolean validationEnabled;

    public ScopeRestrictionBuilder() {
        this(true);
    }

    public ScopeRestrictionBuilder(Boolean validationEnabled) {
        this(new ScopeRestriction(), validationEnabled);
    }

    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ScopeRestriction(), validationEnabled);
    }

    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent, ScopeRestriction instance) {
        this(fluent, instance, true);
    }

    public ScopeRestrictionBuilder(ScopeRestrictionFluent<?> fluent, ScopeRestriction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterRole(instance.getClusterRole());
        fluent.withLiterals(instance.getLiterals());
        this.validationEnabled = validationEnabled;
    }

    public ScopeRestrictionBuilder(ScopeRestriction instance) {
        this(instance, (Boolean)true);
    }

    public ScopeRestrictionBuilder(ScopeRestriction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterRole(instance.getClusterRole());
        this.withLiterals(instance.getLiterals());
        this.validationEnabled = validationEnabled;
    }

    public ScopeRestriction build() {
        ScopeRestriction buildable = new ScopeRestriction(this.fluent.getClusterRole(), this.fluent.getLiterals());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopeRestrictionBuilder that = (ScopeRestrictionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

