/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ListMetaBuilder
extends ListMetaFluentImpl<ListMetaBuilder>
implements VisitableBuilder<ListMeta, ListMetaBuilder> {
    ListMetaFluent<?> fluent;
    Boolean validationEnabled;

    public ListMetaBuilder() {
        this(true);
    }

    public ListMetaBuilder(Boolean validationEnabled) {
        this(new ListMeta(), validationEnabled);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ListMeta(), validationEnabled);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent, ListMeta instance) {
        this(fluent, instance, true);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent, ListMeta instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        this.validationEnabled = validationEnabled;
    }

    public ListMetaBuilder(ListMeta instance) {
        this(instance, (Boolean)true);
    }

    public ListMetaBuilder(ListMeta instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.validationEnabled = validationEnabled;
    }

    public ListMeta build() {
        ListMeta buildable = new ListMeta(this.fluent.getResourceVersion(), this.fluent.getSelfLink());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListMetaBuilder that = (ListMetaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

