package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link CPUTargetUtilization} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCPUTargetUtilizationAssert<S extends AbstractCPUTargetUtilizationAssert<S, A>, A extends CPUTargetUtilization> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCPUTargetUtilizationAssert}</code> to make assertions on actual CPUTargetUtilization.
   * @param actual the CPUTargetUtilization we want to make assertions on.
   */
  protected AbstractCPUTargetUtilizationAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual CPUTargetUtilization we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual CPUTargetUtilization's targetPercentage is equal to the given one.
   * @param targetPercentage the given targetPercentage to compare the actual CPUTargetUtilization's targetPercentage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CPUTargetUtilization's targetPercentage is not equal to the given one.
   */
  public S hasTargetPercentage(Integer targetPercentage) {
    // check that actual CPUTargetUtilization we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetPercentage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualTargetPercentage = actual.getTargetPercentage();
    if (!Objects.areEqual(actualTargetPercentage, targetPercentage)) {
      failWithMessage(assertjErrorMessage, actual, targetPercentage, actualTargetPercentage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
