package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link TLSConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTLSConfigAssert<S extends AbstractTLSConfigAssert<S, A>, A extends TLSConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTLSConfigAssert}</code> to make assertions on actual TLSConfig.
   * @param actual the TLSConfig we want to make assertions on.
   */
  protected AbstractTLSConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property caCertificate so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert caCertificate()  {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCaCertificate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "caCertificate"));
  }


  /**
   * Navigates to the property certificate so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert certificate()  {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCertificate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificate"));
  }


  /**
   * Navigates to the property destinationCACertificate so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert destinationCACertificate()  {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDestinationCACertificate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "destinationCACertificate"));
  }


  /**
   * Navigates to the property insecureEdgeTerminationPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert insecureEdgeTerminationPolicy()  {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getInsecureEdgeTerminationPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "insecureEdgeTerminationPolicy"));
  }


  /**
   * Navigates to the property key so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert key()  {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKey()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "key"));
  }


  /**
   * Navigates to the property termination so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert termination()  {
    // check that actual TLSConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTermination()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "termination"));
  }


}
