/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.PolicyRule;
import io.fabric8.openshift.api.model.PolicyRuleFluent;
import io.fabric8.openshift.api.model.PolicyRuleFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PolicyRuleBuilder
extends PolicyRuleFluentImpl<PolicyRuleBuilder>
implements VisitableBuilder<PolicyRule, PolicyRuleBuilder> {
    PolicyRuleFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyRuleBuilder() {
        this(true);
    }

    public PolicyRuleBuilder(Boolean validationEnabled) {
        this(new PolicyRule(), validationEnabled);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PolicyRule(), validationEnabled);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent, PolicyRule instance) {
        this(fluent, instance, true);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent, PolicyRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withAttributeRestrictions(instance.getAttributeRestrictions());
        fluent.withNonResourceURLs(instance.getNonResourceURLs());
        fluent.withResourceNames(instance.getResourceNames());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public PolicyRuleBuilder(PolicyRule instance) {
        this(instance, (Boolean)true);
    }

    public PolicyRuleBuilder(PolicyRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withAttributeRestrictions(instance.getAttributeRestrictions());
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public PolicyRule build() {
        PolicyRule buildable = new PolicyRule(this.fluent.getApiGroups(), this.fluent.getAttributeRestrictions(), this.fluent.getNonResourceURLs(), this.fluent.getResourceNames(), this.fluent.getResources(), this.fluent.getVerbs());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyRuleBuilder that = (PolicyRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

