package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DockerImage} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDockerImageAssert<S extends AbstractDockerImageAssert<S, A>, A extends DockerImage> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDockerImageAssert}</code> to make assertions on actual DockerImage.
   * @param actual the DockerImage we want to make assertions on.
   */
  protected AbstractDockerImageAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property architecture so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert architecture()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getArchitecture()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "architecture"));
  }


  /**
   * Navigates to the property author so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert author()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getAuthor()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "author"));
  }


  /**
   * Navigates to the property comment so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert comment()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getComment()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "comment"));
  }


  /**
   * Navigates to the property config so that assertions can be done on it
   */
  public DockerConfigAssert config()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DockerConfigAssert) assertThat(actual.getConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "config"));
  }


  /**
   * Navigates to the property container so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert container()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContainer()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "container"));
  }


  /**
   * Navigates to the property containerConfig so that assertions can be done on it
   */
  public DockerConfigAssert containerConfig()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DockerConfigAssert) assertThat(actual.getContainerConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerConfig"));
  }


  /**
   * Navigates to the property created so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert created()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCreated()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "created"));
  }


  /**
   * Navigates to the property dockerVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert dockerVersion()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDockerVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerVersion"));
  }


  /**
   * Navigates to the property id so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert id()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getId()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "id"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property parent so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert parent()  {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getParent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "parent"));
  }


  /**
   * Verifies that the actual DockerImage's size is equal to the given one.
   * @param size the given size to compare the actual DockerImage's size to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerImage's size is not equal to the given one.
   */
  public S hasSize(Long size) {
    // check that actual DockerImage we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting size of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualSize = actual.getSize();
    if (!Objects.areEqual(actualSize, size)) {
      failWithMessage(assertjErrorMessage, actual, size, actualSize);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
