package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DockerConfig} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDockerConfigAssert<S extends AbstractDockerConfigAssert<S, A>, A extends DockerConfig> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDockerConfigAssert}</code> to make assertions on actual DockerConfig.
   * @param actual the DockerConfig we want to make assertions on.
   */
  protected AbstractDockerConfigAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property attachStderr so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert attachStderr()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAttachStderr()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachStderr"));
  }


  /**
   * Navigates to the property attachStdin so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert attachStdin()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAttachStdin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachStdin"));
  }


  /**
   * Navigates to the property attachStdout so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert attachStdout()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAttachStdout()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "attachStdout"));
  }


  /**
   * Navigates to the property cmd so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> cmd()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getCmd(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cmd"));
    return answer;
  }


  /**
   * Verifies that the actual DockerConfig's cpuShares is equal to the given one.
   * @param cpuShares the given cpuShares to compare the actual DockerConfig's cpuShares to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerConfig's cpuShares is not equal to the given one.
   */
  public S hasCpuShares(Long cpuShares) {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cpuShares of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualCpuShares = actual.getCpuShares();
    if (!Objects.areEqual(actualCpuShares, cpuShares)) {
      failWithMessage(assertjErrorMessage, actual, cpuShares, actualCpuShares);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property cpuset so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert cpuset()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCpuset()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cpuset"));
  }


  /**
   * Navigates to the property dns so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> dns()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getDns(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dns"));
    return answer;
  }


  /**
   * Navigates to the property domainname so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert domainname()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDomainname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "domainname"));
  }


  /**
   * Navigates to the property entrypoint so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> entrypoint()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getEntrypoint(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "entrypoint"));
    return answer;
  }


  /**
   * Navigates to the property env so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> env()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getEnv(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"));
    return answer;
  }


  /**
   * Navigates to the property exposedPorts so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert exposedPorts()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getExposedPorts()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "exposedPorts"));
  }


  /**
   * Navigates to the property hostname so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert hostname()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"));
  }


  /**
   * Navigates to the property image so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert image()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"));
  }


  /**
   * Navigates to the property labels so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert labels()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getLabels()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labels"));
  }


  /**
   * Verifies that the actual DockerConfig's memory is equal to the given one.
   * @param memory the given memory to compare the actual DockerConfig's memory to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerConfig's memory is not equal to the given one.
   */
  public S hasMemory(Long memory) {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting memory of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualMemory = actual.getMemory();
    if (!Objects.areEqual(actualMemory, memory)) {
      failWithMessage(assertjErrorMessage, actual, memory, actualMemory);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerConfig's memorySwap is equal to the given one.
   * @param memorySwap the given memorySwap to compare the actual DockerConfig's memorySwap to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerConfig's memorySwap is not equal to the given one.
   */
  public S hasMemorySwap(Long memorySwap) {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting memorySwap of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualMemorySwap = actual.getMemorySwap();
    if (!Objects.areEqual(actualMemorySwap, memorySwap)) {
      failWithMessage(assertjErrorMessage, actual, memorySwap, actualMemorySwap);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property networkDisabled so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert networkDisabled()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getNetworkDisabled()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "networkDisabled"));
  }


  /**
   * Navigates to the property onBuild so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> onBuild()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getOnBuild(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "onBuild"));
    return answer;
  }


  /**
   * Navigates to the property openStdin so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert openStdin()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getOpenStdin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "openStdin"));
  }


  /**
   * Navigates to the property portSpecs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> portSpecs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getPortSpecs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "portSpecs"));
    return answer;
  }


  /**
   * Navigates to the property securityOpts so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> securityOpts()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getSecurityOpts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityOpts"));
    return answer;
  }


  /**
   * Navigates to the property stdinOnce so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert stdinOnce()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getStdinOnce()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "stdinOnce"));
  }


  /**
   * Navigates to the property tty so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert tty()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getTty()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tty"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert user()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


  /**
   * Navigates to the property volumes so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert volumes()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getVolumes()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"));
  }


  /**
   * Navigates to the property volumesFrom so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert volumesFrom()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getVolumesFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumesFrom"));
  }


  /**
   * Navigates to the property workingDir so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert workingDir()  {
    // check that actual DockerConfig we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getWorkingDir()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "workingDir"));
  }


}
