package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link LabelSelector} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLabelSelectorAssert<S extends AbstractLabelSelectorAssert<S, A>, A extends LabelSelector> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLabelSelectorAssert}</code> to make assertions on actual LabelSelector.
   * @param actual the LabelSelector we want to make assertions on.
   */
  protected AbstractLabelSelectorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property matchExpressions so that assertions can be done on it
   */
  public NavigationListAssert<LabelSelectorRequirement, LabelSelectorRequirementAssert> matchExpressions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<LabelSelectorRequirement, LabelSelectorRequirementAssert> assertFactory = new AssertFactory<LabelSelectorRequirement, LabelSelectorRequirementAssert>() {
      public LabelSelectorRequirementAssert createAssert(LabelSelectorRequirement t) {
        return (LabelSelectorRequirementAssert) assertThat(t);
      }
    };
    NavigationListAssert<LabelSelectorRequirement, LabelSelectorRequirementAssert> answer = new NavigationListAssert<LabelSelectorRequirement, LabelSelectorRequirementAssert>(actual.getMatchExpressions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "matchExpressions"));
    return answer;
  }


  /**
   * Navigates to the property matchLabels so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert matchLabels()  {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getMatchLabels()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "matchLabels"));
  }


}
