/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageStreamBuilder
extends ImageStreamFluentImpl<ImageStreamBuilder>
implements VisitableBuilder<ImageStream, ImageStreamBuilder> {
    ImageStreamFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamBuilder() {
        this(true);
    }

    public ImageStreamBuilder(Boolean validationEnabled) {
        this(new ImageStream(), validationEnabled);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageStream(), validationEnabled);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent, ImageStream instance) {
        this(fluent, instance, true);
    }

    public ImageStreamBuilder(ImageStreamFluent<?> fluent, ImageStream instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ImageStreamBuilder(ImageStream instance) {
        this(instance, (Boolean)true);
    }

    public ImageStreamBuilder(ImageStream instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ImageStream build() {
        ImageStream buildable = new ImageStream(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamBuilder that = (ImageStreamBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

