/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluentImpl;

public class ResourceQuotaFluentImpl<A extends ResourceQuotaFluent<A>>
extends BaseFluent<A>
implements ResourceQuotaFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends ResourceQuotaSpec, ?> spec;
    private VisitableBuilder<? extends ResourceQuotaStatus, ?> status;

    public ResourceQuotaFluentImpl() {
    }

    public ResourceQuotaFluentImpl(ResourceQuota instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ResourceQuotaSpec getSpec() {
        return this.spec != null ? (ResourceQuotaSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(ResourceQuotaSpec spec) {
        if (spec != null) {
            this.spec = new ResourceQuotaSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> withNewSpecLike(ResourceQuotaSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ResourceQuotaStatus getStatus() {
        return this.status != null ? (ResourceQuotaStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(ResourceQuotaStatus status) {
        if (status != null) {
            this.status = new ResourceQuotaStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> withNewStatusLike(ResourceQuotaStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ResourceQuotaFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaFluentImpl that = (ResourceQuotaFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends ResourceQuotaStatusFluentImpl<ResourceQuotaFluent.StatusNested<N>>
    implements ResourceQuotaFluent.StatusNested<N>,
    Nested<N> {
        private final ResourceQuotaStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new ResourceQuotaStatusBuilder(this);
        }

        StatusNestedImpl(ResourceQuotaStatus item) {
            this.builder = new ResourceQuotaStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ResourceQuotaSpecFluentImpl<ResourceQuotaFluent.SpecNested<N>>
    implements ResourceQuotaFluent.SpecNested<N>,
    Nested<N> {
        private final ResourceQuotaSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new ResourceQuotaSpecBuilder(this);
        }

        SpecNestedImpl(ResourceQuotaSpec item) {
            this.builder = new ResourceQuotaSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ResourceQuotaFluent.MetadataNested<N>>
    implements ResourceQuotaFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceQuotaFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

