/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.ContextFluent;
import io.fabric8.kubernetes.api.model.ContextFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContextBuilder
extends ContextFluentImpl<ContextBuilder>
implements VisitableBuilder<Context, ContextBuilder> {
    ContextFluent<?> fluent;
    Boolean validationEnabled;

    public ContextBuilder() {
        this(true);
    }

    public ContextBuilder(Boolean validationEnabled) {
        this(new Context(), validationEnabled);
    }

    public ContextBuilder(ContextFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContextBuilder(ContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Context(), validationEnabled);
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance) {
        this(fluent, instance, true);
    }

    public ContextBuilder(ContextFluent<?> fluent, Context instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withExtensions(instance.getExtensions());
        fluent.withNamespace(instance.getNamespace());
        fluent.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public ContextBuilder(Context instance) {
        this(instance, (Boolean)true);
    }

    public ContextBuilder(Context instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withExtensions(instance.getExtensions());
        this.withNamespace(instance.getNamespace());
        this.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public Context build() {
        Context buildable = new Context(this.fluent.getCluster(), this.fluent.getExtensions(), this.fluent.getNamespace(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContextBuilder that = (ContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

