package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DownwardAPIVolumeFile} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDownwardAPIVolumeFileAssert<S extends AbstractDownwardAPIVolumeFileAssert<S, A>, A extends DownwardAPIVolumeFile> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDownwardAPIVolumeFileAssert}</code> to make assertions on actual DownwardAPIVolumeFile.
   * @param actual the DownwardAPIVolumeFile we want to make assertions on.
   */
  protected AbstractDownwardAPIVolumeFileAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DownwardAPIVolumeFile we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fieldRef so that assertions can be done on it
   */
  public ObjectFieldSelectorAssert fieldRef()  {
    // check that actual DownwardAPIVolumeFile we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectFieldSelectorAssert) assertThat(actual.getFieldRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fieldRef"));
  }


  /**
   * Navigates to the property path so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert path()  {
    // check that actual DownwardAPIVolumeFile we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "path"));
  }


  /**
   * Navigates to the property resourceFieldRef so that assertions can be done on it
   */
  public ResourceFieldSelectorAssert resourceFieldRef()  {
    // check that actual DownwardAPIVolumeFile we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceFieldSelectorAssert) assertThat(actual.getResourceFieldRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceFieldRef"));
  }


}
