package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ServiceSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceSpecAssert<S extends AbstractServiceSpecAssert<S, A>, A extends ServiceSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceSpecAssert}</code> to make assertions on actual ServiceSpec.
   * @param actual the ServiceSpec we want to make assertions on.
   */
  protected AbstractServiceSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property clusterIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert clusterIP()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getClusterIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterIP"));
  }


  /**
   * Navigates to the property deprecatedPublicIPs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> deprecatedPublicIPs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getDeprecatedPublicIPs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deprecatedPublicIPs"));
    return answer;
  }


  /**
   * Navigates to the property externalIPs so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> externalIPs()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getExternalIPs(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalIPs"));
    return answer;
  }


  /**
   * Navigates to the property loadBalancerIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert loadBalancerIP()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getLoadBalancerIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancerIP"));
  }


  /**
   * Navigates to the property loadBalancerSourceRanges so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> loadBalancerSourceRanges()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getLoadBalancerSourceRanges(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancerSourceRanges"));
    return answer;
  }


  /**
   * Navigates to the property portalIP so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert portalIP()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPortalIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "portalIP"));
  }


  /**
   * Navigates to the property ports so that assertions can be done on it
   */
  public NavigationListAssert<ServicePort, ServicePortAssert> ports()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<ServicePort, ServicePortAssert> assertFactory = new AssertFactory<ServicePort, ServicePortAssert>() {
      public ServicePortAssert createAssert(ServicePort t) {
        return (ServicePortAssert) assertThat(t);
      }
    };
    NavigationListAssert<ServicePort, ServicePortAssert> answer = new NavigationListAssert<ServicePort, ServicePortAssert>(actual.getPorts(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ports"));
    return answer;
  }


  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert selector()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property sessionAffinity so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert sessionAffinity()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSessionAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sessionAffinity"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual ServiceSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
