package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ResourceRequirements} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceRequirementsAssert<S extends AbstractResourceRequirementsAssert<S, A>, A extends ResourceRequirements> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceRequirementsAssert}</code> to make assertions on actual ResourceRequirements.
   * @param actual the ResourceRequirements we want to make assertions on.
   */
  protected AbstractResourceRequirementsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ResourceRequirements we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property limits so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert limits()  {
    // check that actual ResourceRequirements we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getLimits()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "limits"));
  }


  /**
   * Navigates to the property requests so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert requests()  {
    // check that actual ResourceRequirements we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getRequests()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requests"));
  }


}
