package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeSystemInfo} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeSystemInfoAssert<S extends AbstractNodeSystemInfoAssert<S, A>, A extends NodeSystemInfo> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeSystemInfoAssert}</code> to make assertions on actual NodeSystemInfo.
   * @param actual the NodeSystemInfo we want to make assertions on.
   */
  protected AbstractNodeSystemInfoAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property bootID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert bootID()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getBootID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "bootID"));
  }


  /**
   * Navigates to the property containerRuntimeVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert containerRuntimeVersion()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getContainerRuntimeVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerRuntimeVersion"));
  }


  /**
   * Navigates to the property kernelVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kernelVersion()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKernelVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kernelVersion"));
  }


  /**
   * Navigates to the property kubeProxyVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kubeProxyVersion()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKubeProxyVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kubeProxyVersion"));
  }


  /**
   * Navigates to the property kubeletVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kubeletVersion()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKubeletVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kubeletVersion"));
  }


  /**
   * Navigates to the property machineID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert machineID()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMachineID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "machineID"));
  }


  /**
   * Navigates to the property osImage so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert osImage()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getOsImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "osImage"));
  }


  /**
   * Navigates to the property systemUUID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert systemUUID()  {
    // check that actual NodeSystemInfo we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSystemUUID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "systemUUID"));
  }


}
