package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.AuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.AuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.Capabilities actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert assertThat(io.fabric8.kubernetes.api.model.CapabilitiesBuilder actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert assertThat(io.fabric8.kubernetes.api.model.CapabilitiesFluent actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ClusterAssert assertThat(io.fabric8.kubernetes.api.model.Cluster actual) {
    return new io.fabric8.kubernetes.api.model.ClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigAssert assertThat(io.fabric8.kubernetes.api.model.Config actual) {
    return new io.fabric8.kubernetes.api.model.ConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPortFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContextAssert assertThat(io.fabric8.kubernetes.api.model.Context actual) {
    return new io.fabric8.kubernetes.api.model.ContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableAssert assertThat(io.fabric8.kubernetes.api.model.Doneable actual) {
    return new io.fabric8.kubernetes.api.model.DoneableAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableBaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableBaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableBaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableBaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableCapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableCapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.DoneableCapabilities actual) {
    return new io.fabric8.kubernetes.api.model.DoneableCapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainer actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerState actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpoints actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEnvVarAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEnvVar actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEventAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEvent actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEventListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEventList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableExecActionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableExecAction actual) {
    return new io.fabric8.kubernetes.api.model.DoneableExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableHTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableHTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableHTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.DoneableHTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableHandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableHandlerAssert assertThat(io.fabric8.kubernetes.api.model.DoneableHandler actual) {
    return new io.fabric8.kubernetes.api.model.DoneableHandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableIntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableIntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.DoneableIntOrString actual) {
    return new io.fabric8.kubernetes.api.model.DoneableIntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableKubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableKubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableKubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.DoneableKubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableLifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableLifecycleAssert assertThat(io.fabric8.kubernetes.api.model.DoneableLifecycle actual) {
    return new io.fabric8.kubernetes.api.model.DoneableLifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableListMetaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableListMeta actual) {
    return new io.fabric8.kubernetes.api.model.DoneableListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespace actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNode actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.DoneableObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.DoneableObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.DoneableObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.DoneableObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePod actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodConditionAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodCondition actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodListAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodList actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableProbeAssert assertThat(io.fabric8.kubernetes.api.model.DoneableProbe actual) {
    return new io.fabric8.kubernetes.api.model.DoneableProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableQuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableQuantityAssert assertThat(io.fabric8.kubernetes.api.model.DoneableQuantity actual) {
    return new io.fabric8.kubernetes.api.model.DoneableQuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableRBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableRBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableRBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableRBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecretAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecret actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecretListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecretList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableService actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServicePortAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServicePort actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableTCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableTCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableTCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.DoneableTCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableVolumeAssert assertThat(io.fabric8.kubernetes.api.model.DoneableVolume actual) {
    return new io.fabric8.kubernetes.api.model.DoneableVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableVolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableVolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.DoneableVolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.DoneableVolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableBaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableBaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.EditableBaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.EditableBaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableCapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableCapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.EditableCapabilities actual) {
    return new io.fabric8.kubernetes.api.model.EditableCapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainer actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerState actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointsAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpoints actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EditableEnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EditableEnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableEnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableEnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEventAssert assertThat(io.fabric8.kubernetes.api.model.EditableEvent actual) {
    return new io.fabric8.kubernetes.api.model.EditableEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEventListAssert assertThat(io.fabric8.kubernetes.api.model.EditableEventList actual) {
    return new io.fabric8.kubernetes.api.model.EditableEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableExecActionAssert assertThat(io.fabric8.kubernetes.api.model.EditableExecAction actual) {
    return new io.fabric8.kubernetes.api.model.EditableExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableHTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableHTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.EditableHTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.EditableHTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableHandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableHandlerAssert assertThat(io.fabric8.kubernetes.api.model.EditableHandler actual) {
    return new io.fabric8.kubernetes.api.model.EditableHandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableHostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableHostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableHostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableHostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableIntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableIntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.EditableIntOrString actual) {
    return new io.fabric8.kubernetes.api.model.EditableIntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableKubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableKubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.EditableKubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.EditableKubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.EditableKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.EditableKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableLifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableLifecycleAssert assertThat(io.fabric8.kubernetes.api.model.EditableLifecycle actual) {
    return new io.fabric8.kubernetes.api.model.EditableLifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableListMetaAssert assertThat(io.fabric8.kubernetes.api.model.EditableListMeta actual) {
    return new io.fabric8.kubernetes.api.model.EditableListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableNFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableNFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespace actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeAssert assertThat(io.fabric8.kubernetes.api.model.EditableNode actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeListAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeList actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.EditableObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.EditableObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.EditableObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.EditableObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.EditableObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.EditableObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodAssert assertThat(io.fabric8.kubernetes.api.model.EditablePod actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodConditionAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodCondition actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodListAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodList actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableProbeAssert assertThat(io.fabric8.kubernetes.api.model.EditableProbe actual) {
    return new io.fabric8.kubernetes.api.model.EditableProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableQuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableQuantityAssert assertThat(io.fabric8.kubernetes.api.model.EditableQuantity actual) {
    return new io.fabric8.kubernetes.api.model.EditableQuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableRBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableRBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableRBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableRBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecretAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecret actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecretListAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecretList actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceAssert assertThat(io.fabric8.kubernetes.api.model.EditableService actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceListAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceList actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServicePortAssert assertThat(io.fabric8.kubernetes.api.model.EditableServicePort actual) {
    return new io.fabric8.kubernetes.api.model.EditableServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableTCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableTCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.EditableTCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.EditableTCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableVolumeAssert assertThat(io.fabric8.kubernetes.api.model.EditableVolume actual) {
    return new io.fabric8.kubernetes.api.model.EditableVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableVolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableVolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.EditableVolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.EditableVolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddressBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddressFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPortFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubsetBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubsetFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarFluentAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarFluent actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventAssert assertThat(io.fabric8.kubernetes.api.model.Event actual) {
    return new io.fabric8.kubernetes.api.model.EventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EventBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EventBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventFluentAssert assertThat(io.fabric8.kubernetes.api.model.EventFluent actual) {
    return new io.fabric8.kubernetes.api.model.EventFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListAssert assertThat(io.fabric8.kubernetes.api.model.EventList actual) {
    return new io.fabric8.kubernetes.api.model.EventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EventListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EventListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListFluentAssert assertThat(io.fabric8.kubernetes.api.model.EventListFluent actual) {
    return new io.fabric8.kubernetes.api.model.EventListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventSourceAssert assertThat(io.fabric8.kubernetes.api.model.EventSource actual) {
    return new io.fabric8.kubernetes.api.model.EventSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HandlerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HandlerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerFluentAssert assertThat(io.fabric8.kubernetes.api.model.HandlerFluent actual) {
    return new io.fabric8.kubernetes.api.model.HandlerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HasMetadataAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HasMetadataAssert assertThat(io.fabric8.kubernetes.api.model.HasMetadata actual) {
    return new io.fabric8.kubernetes.api.model.HasMetadataAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringBuilderAssert assertThat(io.fabric8.kubernetes.api.model.IntOrStringBuilder actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringFluentAssert assertThat(io.fabric8.kubernetes.api.model.IntOrStringFluent actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesKindAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesKindAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesKind actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesKindAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResource actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResourceList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleFluentAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleFluent actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaAssert assertThat(io.fabric8.kubernetes.api.model.ListMeta actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ListMetaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ListMetaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerIngress actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerStatus actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.LocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.NamedAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.NamedAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedClusterAssert assertThat(io.fabric8.kubernetes.api.model.NamedCluster actual) {
    return new io.fabric8.kubernetes.api.model.NamedClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedContextAssert assertThat(io.fabric8.kubernetes.api.model.NamedContext actual) {
    return new io.fabric8.kubernetes.api.model.NamedContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedExtensionAssert assertThat(io.fabric8.kubernetes.api.model.NamedExtension actual) {
    return new io.fabric8.kubernetes.api.model.NamedExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceAssert assertThat(io.fabric8.kubernetes.api.model.Namespace actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceListFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAssert assertThat(io.fabric8.kubernetes.api.model.Node actual) {
    return new io.fabric8.kubernetes.api.model.NodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddressBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddressFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.NodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListAssert assertThat(io.fabric8.kubernetes.api.model.NodeList actual) {
    return new io.fabric8.kubernetes.api.model.NodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeListFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfoFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReferenceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReferenceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionAssert assertThat(io.fabric8.kubernetes.api.model.PodCondition actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodConditionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodConditionFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusAssert assertThat(io.fabric8.kubernetes.api.model.PodStatus actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreferencesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreferencesAssert assertThat(io.fabric8.kubernetes.api.model.Preferences actual) {
    return new io.fabric8.kubernetes.api.model.PreferencesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeAssert assertThat(io.fabric8.kubernetes.api.model.Probe actual) {
    return new io.fabric8.kubernetes.api.model.ProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ProbeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ProbeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeFluentAssert assertThat(io.fabric8.kubernetes.api.model.ProbeFluent actual) {
    return new io.fabric8.kubernetes.api.model.ProbeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityAssert assertThat(io.fabric8.kubernetes.api.model.Quantity actual) {
    return new io.fabric8.kubernetes.api.model.QuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityBuilderAssert assertThat(io.fabric8.kubernetes.api.model.QuantityBuilder actual) {
    return new io.fabric8.kubernetes.api.model.QuantityBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityFluentAssert assertThat(io.fabric8.kubernetes.api.model.QuantityFluent actual) {
    return new io.fabric8.kubernetes.api.model.QuantityFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaStatus actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxOptions actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretAssert assertThat(io.fabric8.kubernetes.api.model.Secret actual) {
    return new io.fabric8.kubernetes.api.model.SecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListAssert assertThat(io.fabric8.kubernetes.api.model.SecretList actual) {
    return new io.fabric8.kubernetes.api.model.SecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretListFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortAssert assertThat(io.fabric8.kubernetes.api.model.ServicePort actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServicePortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServicePortFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusAssert assertThat(io.fabric8.kubernetes.api.model.Status actual) {
    return new io.fabric8.kubernetes.api.model.StatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.StatusCause actual) {
    return new io.fabric8.kubernetes.api.model.StatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.StatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.StatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WatchEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WatchEventAssert assertThat(io.fabric8.kubernetes.api.model.WatchEvent actual) {
    return new io.fabric8.kubernetes.api.model.WatchEventAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
