package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link GitRepoVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGitRepoVolumeSourceAssert<S extends AbstractGitRepoVolumeSourceAssert<S, A>, A extends GitRepoVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGitRepoVolumeSourceAssert}</code> to make assertions on actual GitRepoVolumeSource.
   * @param actual the GitRepoVolumeSource we want to make assertions on.
   */
  protected AbstractGitRepoVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual GitRepoVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property directory so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert directory()  {
    // check that actual GitRepoVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDirectory()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "directory"));
  }


  /**
   * Navigates to the property repository so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert repository()  {
    // check that actual GitRepoVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRepository()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "repository"));
  }


  /**
   * Navigates to the property revision so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert revision()  {
    // check that actual GitRepoVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "revision"));
  }


}
