/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategy;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigBuilder;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigFluentImpl;

public class DeploymentSpecFluentImpl<A extends DeploymentSpecFluent<A>>
extends BaseFluent<A>
implements DeploymentSpecFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private VisitableBuilder<? extends RollbackConfig, ?> rollbackTo;
    private VisitableBuilder<? extends LabelSelector, ?> selector;
    private VisitableBuilder<? extends DeploymentStrategy, ?> strategy;
    private VisitableBuilder<? extends PodTemplateSpec, ?> template;

    public DeploymentSpecFluentImpl() {
    }

    public DeploymentSpecFluentImpl(DeploymentSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withRollbackTo(instance.getRollbackTo());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean isPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public RollbackConfig getRollbackTo() {
        return this.rollbackTo != null ? (RollbackConfig)this.rollbackTo.build() : null;
    }

    @Override
    public A withRollbackTo(RollbackConfig rollbackTo) {
        if (rollbackTo != null) {
            this.rollbackTo = new RollbackConfigBuilder(rollbackTo);
            this._visitables.add(this.rollbackTo);
        }
        return (A)this;
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo() {
        return new RollbackToNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.RollbackToNested<A> editRollbackTo() {
        return this.withNewRollbackToLike(this.getRollbackTo());
    }

    @Override
    public A withNewRollbackTo(Long revision) {
        return this.withRollbackTo(new RollbackConfig(revision));
    }

    @Override
    public LabelSelector getSelector() {
        return this.selector != null ? (LabelSelector)this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.add(this.selector);
        }
        return (A)this;
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? (DeploymentStrategy)this.strategy.build() : null;
    }

    @Override
    public A withStrategy(DeploymentStrategy strategy) {
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (A)this;
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DeploymentSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentSpecFluentImpl that = (DeploymentSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.paused != null ? !this.paused.equals(that.paused) : that.paused != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.rollbackTo != null ? !this.rollbackTo.equals(that.rollbackTo) : that.rollbackTo != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DeploymentSpecFluent.TemplateNested<N>>
    implements DeploymentSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N endTemplate() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withTemplate(this.builder.build());
        }
    }

    public class StrategyNestedImpl<N>
    extends DeploymentStrategyFluentImpl<DeploymentSpecFluent.StrategyNested<N>>
    implements DeploymentSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final DeploymentStrategyBuilder builder;

        StrategyNestedImpl() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        StrategyNestedImpl(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        @Override
        public N endStrategy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withStrategy(this.builder.build());
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<DeploymentSpecFluent.SelectorNested<N>>
    implements DeploymentSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N endSelector() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withSelector(this.builder.build());
        }
    }

    public class RollbackToNestedImpl<N>
    extends RollbackConfigFluentImpl<DeploymentSpecFluent.RollbackToNested<N>>
    implements DeploymentSpecFluent.RollbackToNested<N>,
    Nested<N> {
        private final RollbackConfigBuilder builder;

        RollbackToNestedImpl() {
            this.builder = new RollbackConfigBuilder(this);
        }

        RollbackToNestedImpl(RollbackConfig item) {
            this.builder = new RollbackConfigBuilder(this, item);
        }

        @Override
        public N endRollbackTo() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentSpecFluentImpl.this.withRollbackTo(this.builder.build());
        }
    }
}

