package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link GitSourceRevision} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGitSourceRevisionAssert<S extends AbstractGitSourceRevisionAssert<S, A>, A extends GitSourceRevision> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGitSourceRevisionAssert}</code> to make assertions on actual GitSourceRevision.
   * @param actual the GitSourceRevision we want to make assertions on.
   */
  protected AbstractGitSourceRevisionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual GitSourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property author so that assertions can be done on it
   */
  public SourceControlUserAssert author()  {
    // check that actual GitSourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SourceControlUserAssert) assertThat(actual.getAuthor()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "author"));
  }


  /**
   * Navigates to the property commit so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert commit()  {
    // check that actual GitSourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCommit()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "commit"));
  }


  /**
   * Navigates to the property committer so that assertions can be done on it
   */
  public SourceControlUserAssert committer()  {
    // check that actual GitSourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SourceControlUserAssert) assertThat(actual.getCommitter()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "committer"));
  }


  /**
   * Navigates to the property message so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert message()  {
    // check that actual GitSourceRevision we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMessage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "message"));
  }


}
