package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentConfigSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentConfigSpecAssert<S extends AbstractDeploymentConfigSpecAssert<S, A>, A extends DeploymentConfigSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentConfigSpecAssert}</code> to make assertions on actual DeploymentConfigSpec.
   * @param actual the DeploymentConfigSpec we want to make assertions on.
   */
  protected AbstractDeploymentConfigSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual DeploymentConfigSpec's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentConfigSpec's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpec's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentConfigSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert selector()  {
    // check that actual DeploymentConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property strategy so that assertions can be done on it
   */
  public DeploymentStrategyAssert strategy()  {
    // check that actual DeploymentConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeploymentStrategyAssert) assertThat(actual.getStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strategy"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.PodTemplateSpecAssert template()  {
    // check that actual DeploymentConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.PodTemplateSpecAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


  /**
   * Navigates to the property test so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert test()  {
    // check that actual DeploymentConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getTest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "test"));
  }


  /**
   * Navigates to the property triggers so that assertions can be done on it
   */
  public NavigationListAssert<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert> triggers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert> assertFactory = new AssertFactory<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert>() {
      public DeploymentTriggerPolicyAssert createAssert(DeploymentTriggerPolicy t) {
        return (DeploymentTriggerPolicyAssert) assertThat(t);
      }
    };
    NavigationListAssert<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert> answer = new NavigationListAssert<DeploymentTriggerPolicy, DeploymentTriggerPolicyAssert>(actual.getTriggers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "triggers"));
    return answer;
  }


}
