package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildConfigStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildConfigStatusAssert<S extends AbstractBuildConfigStatusAssert<S, A>, A extends BuildConfigStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildConfigStatusAssert}</code> to make assertions on actual BuildConfigStatus.
   * @param actual the BuildConfigStatus we want to make assertions on.
   */
  protected AbstractBuildConfigStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual BuildConfigStatus's lastVersion is equal to the given one.
   * @param lastVersion the given lastVersion to compare the actual BuildConfigStatus's lastVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigStatus's lastVersion is not equal to the given one.
   */
  public S hasLastVersion(Integer lastVersion) {
    // check that actual BuildConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLastVersion = actual.getLastVersion();
    if (!Objects.areEqual(actualLastVersion, lastVersion)) {
      failWithMessage(assertjErrorMessage, actual, lastVersion, actualLastVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
