package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ScaleStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScaleStatusAssert<S extends AbstractScaleStatusAssert<S, A>, A extends ScaleStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScaleStatusAssert}</code> to make assertions on actual ScaleStatus.
   * @param actual the ScaleStatus we want to make assertions on.
   */
  protected AbstractScaleStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ScaleStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual ScaleStatus's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ScaleStatus's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleStatus's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ScaleStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property selector so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert selector()  {
    // check that actual ScaleStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"));
  }


  /**
   * Navigates to the property targetSelector so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert targetSelector()  {
    // check that actual ScaleStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getTargetSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "targetSelector"));
  }


}
