/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamespaceListFluent<T extends NamespaceListFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    NamespaceList.ApiVersion apiVersion;
    List<VisitableBuilder<Namespace, ?>> items = new ArrayList();
    String kind;
    VisitableBuilder<ListMeta, ?> metadata;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public NamespaceList.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(NamespaceList.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public T addToItems(Namespace ... items) {
        for (Namespace item : items) {
            NamespaceBuilder builder = new NamespaceBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (T)((Object)this);
    }

    public List<Namespace> getItems() {
        return this.build(this.items);
    }

    public T withItems(List<Namespace> items) {
        this.items.clear();
        if (items != null) {
            for (Namespace item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public T withItems(Namespace ... items) {
        this.items.clear();
        if (items != null) {
            for (Namespace item : items) {
                this.addToItems(item);
            }
        }
        return (T)((Object)this);
    }

    public ItemsNested<T> addNewItem() {
        return new ItemsNested();
    }

    public ItemsNested<T> addNewItemLike(Namespace item) {
        return new ItemsNested(item);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNested() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        public N and() {
            return (N)NamespaceListFluent.this.withMetadata(this.builder.build());
        }
    }

    public class ItemsNested<N>
    extends NamespaceFluent<ItemsNested<N>>
    implements Nested<N> {
        private final NamespaceBuilder builder;

        ItemsNested() {
            this.builder = new NamespaceBuilder(this);
        }

        ItemsNested(Namespace item) {
            this.builder = new NamespaceBuilder(this, item);
        }

        public N endItem() {
            return this.and();
        }

        public N and() {
            return (N)NamespaceListFluent.this.addToItems(this.builder.build());
        }
    }
}

