/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractPodSpecAssert<S extends AbstractPodSpecAssert<S, A>, A extends PodSpec>
extends AbstractAssert<S, A> {
    protected AbstractPodSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualActiveDeadlineSeconds = ((PodSpec)this.actual).getActiveDeadlineSeconds();
        if (!Objects.areEqual((Object)actualActiveDeadlineSeconds, (Object)activeDeadlineSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, activeDeadlineSeconds, actualActiveDeadlineSeconds});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((PodSpec)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasContainers(Container ... containers) {
        this.isNotNull();
        if (containers == null) {
            throw new AssertionError((Object)"Expecting containers parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpec)this.actual).getContainers(), (Object[])containers);
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNoContainers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have containers but had :\n  <%s>";
        if (((PodSpec)this.actual).getContainers().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpec)this.actual).getContainers()});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasDnsPolicy(String dnsPolicy) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected dnsPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDnsPolicy = ((PodSpec)this.actual).getDnsPolicy();
        if (!Objects.areEqual((Object)actualDnsPolicy, (Object)dnsPolicy)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, dnsPolicy, actualDnsPolicy});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasHostNetwork(Boolean hostNetwork) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected hostNetwork of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Boolean actualHostNetwork = ((PodSpec)this.actual).getHostNetwork();
        if (!Objects.areEqual((Object)actualHostNetwork, (Object)hostNetwork)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, hostNetwork, actualHostNetwork});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        this.isNotNull();
        if (imagePullSecrets == null) {
            throw new AssertionError((Object)"Expecting imagePullSecrets parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpec)this.actual).getImagePullSecrets(), (Object[])imagePullSecrets);
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNoImagePullSecrets() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have imagePullSecrets but had :\n  <%s>";
        if (((PodSpec)this.actual).getImagePullSecrets().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpec)this.actual).getImagePullSecrets()});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNodeName(String nodeName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected nodeName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualNodeName = ((PodSpec)this.actual).getNodeName();
        if (!Objects.areEqual((Object)actualNodeName, (Object)nodeName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodeName, actualNodeName});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNodeSelector(Map nodeSelector) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected nodeSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualNodeSelector = ((PodSpec)this.actual).getNodeSelector();
        if (!Objects.areEqual(actualNodeSelector, (Object)nodeSelector)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodeSelector, actualNodeSelector});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasRestartPolicy(String restartPolicy) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected restartPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRestartPolicy = ((PodSpec)this.actual).getRestartPolicy();
        if (!Objects.areEqual((Object)actualRestartPolicy, (Object)restartPolicy)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, restartPolicy, actualRestartPolicy});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasServiceAccountName(String serviceAccountName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected serviceAccountName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualServiceAccountName = ((PodSpec)this.actual).getServiceAccountName();
        if (!Objects.areEqual((Object)actualServiceAccountName, (Object)serviceAccountName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, serviceAccountName, actualServiceAccountName});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected terminationGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualTerminationGracePeriodSeconds = ((PodSpec)this.actual).getTerminationGracePeriodSeconds();
        if (!Objects.areEqual((Object)actualTerminationGracePeriodSeconds, (Object)terminationGracePeriodSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, terminationGracePeriodSeconds, actualTerminationGracePeriodSeconds});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasVolumes(Volume ... volumes) {
        this.isNotNull();
        if (volumes == null) {
            throw new AssertionError((Object)"Expecting volumes parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpec)this.actual).getVolumes(), (Object[])volumes);
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNoVolumes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumes but had :\n  <%s>";
        if (((PodSpec)this.actual).getVolumes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpec)this.actual).getVolumes()});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }
}

