package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerStateRunningFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStateRunningFluentAssert<S extends AbstractContainerStateRunningFluentAssert<S, A>, A extends ContainerStateRunningFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStateRunningFluentAssert}</code> to make assertions on actual ContainerStateRunningFluent.
   * @param actual the ContainerStateRunningFluent we want to make assertions on.
   */
  protected AbstractContainerStateRunningFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerStateRunningFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerStateRunningFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateRunningFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerStateRunningFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateRunningFluent's startedAt is equal to the given one.
   * @param startedAt the given startedAt to compare the actual ContainerStateRunningFluent's startedAt to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateRunningFluent's startedAt is not equal to the given one.
   */
  public S hasStartedAt(String startedAt) {
    // check that actual ContainerStateRunningFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected startedAt of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStartedAt = actual.getStartedAt();
    if (!Objects.areEqual(actualStartedAt, startedAt)) {
      failWithMessage(assertjErrorMessage, actual, startedAt, actualStartedAt);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
