package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PodTemplateSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateSpecAssert<S extends AbstractPodTemplateSpecAssert<S, A>, A extends PodTemplateSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateSpecAssert}</code> to make assertions on actual PodTemplateSpec.
   * @param actual the PodTemplateSpec we want to make assertions on.
   */
  protected AbstractPodTemplateSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property spec so that assertions can be done on it
   */
  public PodSpecAssert spec()  {
    // check that actual PodTemplateSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodSpecAssert) assertThat(actual.getSpec()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "spec"));
  }


}
