package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link NodeDaemonEndpoints} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeDaemonEndpointsAssert<S extends AbstractNodeDaemonEndpointsAssert<S, A>, A extends NodeDaemonEndpoints> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeDaemonEndpointsAssert}</code> to make assertions on actual NodeDaemonEndpoints.
   * @param actual the NodeDaemonEndpoints we want to make assertions on.
   */
  protected AbstractNodeDaemonEndpointsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NodeDaemonEndpoints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property kubeletEndpoint so that assertions can be done on it
   */
  public DaemonEndpointAssert kubeletEndpoint()  {
    // check that actual NodeDaemonEndpoints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DaemonEndpointAssert) assertThat(actual.getKubeletEndpoint()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kubeletEndpoint"));
  }


}
