/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions.support;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.assertions.support.PodWatcher;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PodLogWatcher
implements Closeable {
    private final LogWatch logWatch;

    public PodLogWatcher(PodWatcher podWatcher, String name, Pod pod, File logFile) throws FileNotFoundException {
        KubernetesClient client = podWatcher.getClient();
        ObjectMeta metadata = pod.getMetadata();
        logFile.getParentFile().mkdirs();
        this.logWatch = (LogWatch)((ClientPodResource)((ClientNonNamespaceOperation)client.pods().inNamespace(metadata.getNamespace())).withName(name)).watchLog((OutputStream)new FileOutputStream(logFile));
    }

    @Override
    public void close() throws IOException {
        if (this.logWatch != null) {
            this.logWatch.close();
        }
    }
}

