/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetailsFluent;
import io.fabric8.kubernetes.api.model.StatusDetailsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatusDetailsBuilder
extends StatusDetailsFluentImpl<StatusDetailsBuilder>
implements VisitableBuilder<StatusDetails, StatusDetailsBuilder> {
    StatusDetailsFluent<?> fluent;
    Boolean validationEnabled;

    public StatusDetailsBuilder() {
        this(true);
    }

    public StatusDetailsBuilder(Boolean validationEnabled) {
        this(new StatusDetails(), validationEnabled);
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatusDetails(), validationEnabled);
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent, StatusDetails instance) {
        this(fluent, instance, true);
    }

    public StatusDetailsBuilder(StatusDetailsFluent<?> fluent, StatusDetails instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCauses(instance.getCauses());
        fluent.withGroup(instance.getGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withRetryAfterSeconds(instance.getRetryAfterSeconds());
        this.validationEnabled = validationEnabled;
    }

    public StatusDetailsBuilder(StatusDetails instance) {
        this(instance, (Boolean)true);
    }

    public StatusDetailsBuilder(StatusDetails instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCauses(instance.getCauses());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
        this.validationEnabled = validationEnabled;
    }

    public StatusDetails build() {
        StatusDetails buildable = new StatusDetails(this.fluent.getCauses(), this.fluent.getGroup(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getRetryAfterSeconds());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusDetailsBuilder that = (StatusDetailsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

