/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.APIVersion;
import io.fabric8.kubernetes.api.model.extensions.APIVersionFluent;
import io.fabric8.kubernetes.api.model.extensions.APIVersionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class APIVersionBuilder
extends APIVersionFluentImpl<APIVersionBuilder>
implements VisitableBuilder<APIVersion, APIVersionBuilder> {
    APIVersionFluent<?> fluent;
    Boolean validationEnabled;

    public APIVersionBuilder() {
        this(true);
    }

    public APIVersionBuilder(Boolean validationEnabled) {
        this(new APIVersion(), validationEnabled);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIVersion(), validationEnabled);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent, APIVersion instance) {
        this(fluent, instance, true);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent, APIVersion instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public APIVersionBuilder(APIVersion instance) {
        this(instance, (Boolean)true);
    }

    public APIVersionBuilder(APIVersion instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public APIVersion build() {
        APIVersion buildable = new APIVersion(this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIVersionBuilder that = (APIVersionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

