/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"args", "command", "env", "image", "imagePullPolicy", "lifecycle", "livenessProbe", "name", "ports", "readinessProbe", "resources", "securityContext", "stdin", "stdinOnce", "terminationMessagePath", "tty", "volumeMounts", "workingDir"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Container
implements KubernetesResource {
    @JsonProperty(value="args")
    @Valid
    private List<String> args = new ArrayList<String>();
    @JsonProperty(value="command")
    @Valid
    private List<String> command = new ArrayList<String>();
    @JsonProperty(value="env")
    @Valid
    private List<EnvVar> env = new ArrayList<EnvVar>();
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="imagePullPolicy")
    private String imagePullPolicy;
    @JsonProperty(value="lifecycle")
    @Valid
    private Lifecycle lifecycle;
    @JsonProperty(value="livenessProbe")
    @Valid
    private Probe livenessProbe;
    @JsonProperty(value="name")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?$")
    @Size(max=63)
    private String name;
    @JsonProperty(value="ports")
    @Valid
    private List<ContainerPort> ports = new ArrayList<ContainerPort>();
    @JsonProperty(value="readinessProbe")
    @Valid
    private Probe readinessProbe;
    @JsonProperty(value="resources")
    @Valid
    private ResourceRequirements resources;
    @JsonProperty(value="securityContext")
    @Valid
    private SecurityContext securityContext;
    @JsonProperty(value="stdin")
    private Boolean stdin;
    @JsonProperty(value="stdinOnce")
    private Boolean stdinOnce;
    @JsonProperty(value="terminationMessagePath")
    private String terminationMessagePath;
    @JsonProperty(value="tty")
    private Boolean tty;
    @JsonProperty(value="volumeMounts")
    @Valid
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    @JsonProperty(value="workingDir")
    private String workingDir;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Container() {
    }

    public Container(List<String> args, List<String> command, List<EnvVar> env, String image, String imagePullPolicy, Lifecycle lifecycle, Probe livenessProbe, String name, List<ContainerPort> ports, Probe readinessProbe, ResourceRequirements resources, SecurityContext securityContext, Boolean stdin, Boolean stdinOnce, String terminationMessagePath, Boolean tty, List<VolumeMount> volumeMounts, String workingDir) {
        this.args = args;
        this.command = command;
        this.env = env;
        this.image = image;
        this.imagePullPolicy = imagePullPolicy;
        this.lifecycle = lifecycle;
        this.livenessProbe = livenessProbe;
        this.name = name;
        this.ports = ports;
        this.readinessProbe = readinessProbe;
        this.resources = resources;
        this.securityContext = securityContext;
        this.stdin = stdin;
        this.stdinOnce = stdinOnce;
        this.terminationMessagePath = terminationMessagePath;
        this.tty = tty;
        this.volumeMounts = volumeMounts;
        this.workingDir = workingDir;
    }

    @JsonProperty(value="args")
    public List<String> getArgs() {
        return this.args;
    }

    @JsonProperty(value="args")
    public void setArgs(List<String> args) {
        this.args = args;
    }

    @JsonProperty(value="command")
    public List<String> getCommand() {
        return this.command;
    }

    @JsonProperty(value="command")
    public void setCommand(List<String> command) {
        this.command = command;
    }

    @JsonProperty(value="env")
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @JsonProperty(value="env")
    public void setEnv(List<EnvVar> env) {
        this.env = env;
    }

    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    public void setImage(String image) {
        this.image = image;
    }

    @JsonProperty(value="imagePullPolicy")
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @JsonProperty(value="imagePullPolicy")
    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @JsonProperty(value="lifecycle")
    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    @JsonProperty(value="livenessProbe")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    @JsonProperty(value="livenessProbe")
    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="ports")
    public List<ContainerPort> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="ports")
    public void setPorts(List<ContainerPort> ports) {
        this.ports = ports;
    }

    @JsonProperty(value="readinessProbe")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    @JsonProperty(value="readinessProbe")
    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @JsonProperty(value="resources")
    public ResourceRequirements getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    @JsonProperty(value="securityContext")
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @JsonProperty(value="securityContext")
    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @JsonProperty(value="stdin")
    public Boolean getStdin() {
        return this.stdin;
    }

    @JsonProperty(value="stdin")
    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    @JsonProperty(value="stdinOnce")
    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    @JsonProperty(value="stdinOnce")
    public void setStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    @JsonProperty(value="terminationMessagePath")
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    @JsonProperty(value="terminationMessagePath")
    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    @JsonProperty(value="tty")
    public Boolean getTty() {
        return this.tty;
    }

    @JsonProperty(value="tty")
    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    @JsonProperty(value="volumeMounts")
    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    @JsonProperty(value="volumeMounts")
    public void setVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    @JsonProperty(value="workingDir")
    public String getWorkingDir() {
        return this.workingDir;
    }

    @JsonProperty(value="workingDir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Container(args=" + this.getArgs() + ", command=" + this.getCommand() + ", env=" + this.getEnv() + ", image=" + this.getImage() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", lifecycle=" + this.getLifecycle() + ", livenessProbe=" + this.getLivenessProbe() + ", name=" + this.getName() + ", ports=" + this.getPorts() + ", readinessProbe=" + this.getReadinessProbe() + ", resources=" + this.getResources() + ", securityContext=" + this.getSecurityContext() + ", stdin=" + this.getStdin() + ", stdinOnce=" + this.getStdinOnce() + ", terminationMessagePath=" + this.getTerminationMessagePath() + ", tty=" + this.getTty() + ", volumeMounts=" + this.getVolumeMounts() + ", workingDir=" + this.getWorkingDir() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$args = this.getArgs();
        List<String> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        List<String> this$command = this.getCommand();
        List<String> other$command = other.getCommand();
        if (this$command == null ? other$command != null : !((Object)this$command).equals(other$command)) {
            return false;
        }
        List<EnvVar> this$env = this.getEnv();
        List<EnvVar> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)this$lifecycle).equals(other$lifecycle)) {
            return false;
        }
        Probe this$livenessProbe = this.getLivenessProbe();
        Probe other$livenessProbe = other.getLivenessProbe();
        if (this$livenessProbe == null ? other$livenessProbe != null : !((Object)this$livenessProbe).equals(other$livenessProbe)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ContainerPort> this$ports = this.getPorts();
        List<ContainerPort> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        Probe this$readinessProbe = this.getReadinessProbe();
        Probe other$readinessProbe = other.getReadinessProbe();
        if (this$readinessProbe == null ? other$readinessProbe != null : !((Object)this$readinessProbe).equals(other$readinessProbe)) {
            return false;
        }
        ResourceRequirements this$resources = this.getResources();
        ResourceRequirements other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        SecurityContext this$securityContext = this.getSecurityContext();
        SecurityContext other$securityContext = other.getSecurityContext();
        if (this$securityContext == null ? other$securityContext != null : !((Object)this$securityContext).equals(other$securityContext)) {
            return false;
        }
        Boolean this$stdin = this.getStdin();
        Boolean other$stdin = other.getStdin();
        if (this$stdin == null ? other$stdin != null : !((Object)this$stdin).equals(other$stdin)) {
            return false;
        }
        Boolean this$stdinOnce = this.getStdinOnce();
        Boolean other$stdinOnce = other.getStdinOnce();
        if (this$stdinOnce == null ? other$stdinOnce != null : !((Object)this$stdinOnce).equals(other$stdinOnce)) {
            return false;
        }
        String this$terminationMessagePath = this.getTerminationMessagePath();
        String other$terminationMessagePath = other.getTerminationMessagePath();
        if (this$terminationMessagePath == null ? other$terminationMessagePath != null : !this$terminationMessagePath.equals(other$terminationMessagePath)) {
            return false;
        }
        Boolean this$tty = this.getTty();
        Boolean other$tty = other.getTty();
        if (this$tty == null ? other$tty != null : !((Object)this$tty).equals(other$tty)) {
            return false;
        }
        List<VolumeMount> this$volumeMounts = this.getVolumeMounts();
        List<VolumeMount> other$volumeMounts = other.getVolumeMounts();
        if (this$volumeMounts == null ? other$volumeMounts != null : !((Object)this$volumeMounts).equals(other$volumeMounts)) {
            return false;
        }
        String this$workingDir = this.getWorkingDir();
        String other$workingDir = other.getWorkingDir();
        if (this$workingDir == null ? other$workingDir != null : !this$workingDir.equals(other$workingDir)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Container;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        List<String> $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
        List<EnvVar> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)$lifecycle).hashCode());
        Probe $livenessProbe = this.getLivenessProbe();
        result = result * 59 + ($livenessProbe == null ? 43 : ((Object)$livenessProbe).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ContainerPort> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        Probe $readinessProbe = this.getReadinessProbe();
        result = result * 59 + ($readinessProbe == null ? 43 : ((Object)$readinessProbe).hashCode());
        ResourceRequirements $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        SecurityContext $securityContext = this.getSecurityContext();
        result = result * 59 + ($securityContext == null ? 43 : ((Object)$securityContext).hashCode());
        Boolean $stdin = this.getStdin();
        result = result * 59 + ($stdin == null ? 43 : ((Object)$stdin).hashCode());
        Boolean $stdinOnce = this.getStdinOnce();
        result = result * 59 + ($stdinOnce == null ? 43 : ((Object)$stdinOnce).hashCode());
        String $terminationMessagePath = this.getTerminationMessagePath();
        result = result * 59 + ($terminationMessagePath == null ? 43 : $terminationMessagePath.hashCode());
        Boolean $tty = this.getTty();
        result = result * 59 + ($tty == null ? 43 : ((Object)$tty).hashCode());
        List<VolumeMount> $volumeMounts = this.getVolumeMounts();
        result = result * 59 + ($volumeMounts == null ? 43 : ((Object)$volumeMounts).hashCode());
        String $workingDir = this.getWorkingDir();
        result = result * 59 + ($workingDir == null ? 43 : $workingDir.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

