/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.GitSourceRevision;
import io.fabric8.openshift.api.model.GitSourceRevisionFluent;
import io.fabric8.openshift.api.model.SourceControlUser;
import io.fabric8.openshift.api.model.SourceControlUserBuilder;
import io.fabric8.openshift.api.model.SourceControlUserFluentImpl;

public class GitSourceRevisionFluentImpl<A extends GitSourceRevisionFluent<A>>
extends BaseFluent<A>
implements GitSourceRevisionFluent<A> {
    private VisitableBuilder<? extends SourceControlUser, ?> author;
    private String commit;
    private VisitableBuilder<? extends SourceControlUser, ?> committer;
    private String message;

    public GitSourceRevisionFluentImpl() {
    }

    public GitSourceRevisionFluentImpl(GitSourceRevision instance) {
        this.withAuthor(instance.getAuthor());
        this.withCommit(instance.getCommit());
        this.withCommitter(instance.getCommitter());
        this.withMessage(instance.getMessage());
    }

    @Override
    public SourceControlUser getAuthor() {
        return this.author != null ? (SourceControlUser)this.author.build() : null;
    }

    @Override
    public A withAuthor(SourceControlUser author) {
        if (author != null) {
            this.author = new SourceControlUserBuilder(author);
            this._visitables.add(this.author);
        }
        return (A)this;
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthor() {
        return new AuthorNestedImpl();
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> withNewAuthorLike(SourceControlUser item) {
        return new AuthorNestedImpl(item);
    }

    @Override
    public GitSourceRevisionFluent.AuthorNested<A> editAuthor() {
        return this.withNewAuthorLike(this.getAuthor());
    }

    @Override
    public A withNewAuthor(String email, String name) {
        return this.withAuthor(new SourceControlUser(email, name));
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    @Override
    public A withCommit(String commit) {
        this.commit = commit;
        return (A)this;
    }

    @Override
    public SourceControlUser getCommitter() {
        return this.committer != null ? (SourceControlUser)this.committer.build() : null;
    }

    @Override
    public A withCommitter(SourceControlUser committer) {
        if (committer != null) {
            this.committer = new SourceControlUserBuilder(committer);
            this._visitables.add(this.committer);
        }
        return (A)this;
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitter() {
        return new CommitterNestedImpl();
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> withNewCommitterLike(SourceControlUser item) {
        return new CommitterNestedImpl(item);
    }

    @Override
    public GitSourceRevisionFluent.CommitterNested<A> editCommitter() {
        return this.withNewCommitterLike(this.getCommitter());
    }

    @Override
    public A withNewCommitter(String email, String name) {
        return this.withCommitter(new SourceControlUser(email, name));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitSourceRevisionFluentImpl that = (GitSourceRevisionFluentImpl)o;
        if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
            return false;
        }
        if (this.commit != null ? !this.commit.equals(that.commit) : that.commit != null) {
            return false;
        }
        if (this.committer != null ? !this.committer.equals(that.committer) : that.committer != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    public class CommitterNestedImpl<N>
    extends SourceControlUserFluentImpl<GitSourceRevisionFluent.CommitterNested<N>>
    implements GitSourceRevisionFluent.CommitterNested<N>,
    Nested<N> {
        private final SourceControlUserBuilder builder;

        CommitterNestedImpl() {
            this.builder = new SourceControlUserBuilder(this);
        }

        CommitterNestedImpl(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GitSourceRevisionFluentImpl.this.withCommitter(this.builder.build());
        }

        @Override
        public N endCommitter() {
            return this.and();
        }
    }

    public class AuthorNestedImpl<N>
    extends SourceControlUserFluentImpl<GitSourceRevisionFluent.AuthorNested<N>>
    implements GitSourceRevisionFluent.AuthorNested<N>,
    Nested<N> {
        private final SourceControlUserBuilder builder;

        AuthorNestedImpl() {
            this.builder = new SourceControlUserBuilder(this);
        }

        AuthorNestedImpl(SourceControlUser item) {
            this.builder = new SourceControlUserBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)GitSourceRevisionFluentImpl.this.withAuthor(this.builder.build());
        }

        @Override
        public N endAuthor() {
            return this.and();
        }
    }
}

