/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingFluent;
import java.util.ArrayList;
import java.util.List;

public class RoleBindingFluentImpl<A extends RoleBindingFluent<A>>
extends BaseFluent<A>
implements RoleBindingFluent<A> {
    private String apiVersion;
    private List<String> groupNames = new ArrayList<String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends ObjectReference, ?> roleRef;
    private List<VisitableBuilder<? extends ObjectReference, ?>> subjects = new ArrayList();
    private List<String> userNames = new ArrayList<String>();

    public RoleBindingFluentImpl() {
    }

    public RoleBindingFluentImpl(RoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public A withGroupNames(List<String> groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroupNames(String ... groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ObjectReference getRoleRef() {
        return this.roleRef != null ? (ObjectReference)this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(ObjectReference roleRef) {
        if (roleRef != null) {
            this.roleRef = new ObjectReferenceBuilder(roleRef);
            this._visitables.add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public A addToSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ObjectReference> getSubjects() {
        return RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public A withSubjects(List<ObjectReference> subjects) {
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSubjects(ObjectReference ... subjects) {
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item) {
        return new SubjectsNestedImpl(item);
    }

    @Override
    public A addToUserNames(String ... items) {
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserNames(String ... items) {
        for (String item : items) {
            this.userNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUserNames() {
        return this.userNames;
    }

    @Override
    public A withUserNames(List<String> userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withUserNames(String ... userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBindingFluentImpl that = (RoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupNames != null ? !this.groupNames.equals(that.groupNames) : that.groupNames != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        if (this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null) {
            return false;
        }
        return !(this.userNames != null ? !this.userNames.equals(that.userNames) : that.userNames != null);
    }

    public class SubjectsNestedImpl<N>
    extends ObjectReferenceFluentImpl<RoleBindingFluent.SubjectsNested<N>>
    implements RoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        SubjectsNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        SubjectsNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.addToSubjects(this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<RoleBindingFluent.RoleRefNested<N>>
    implements RoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        RoleRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        RoleRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RoleBindingFluent.MetadataNested<N>>
    implements RoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

