/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.EndpointAddressFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointAddressBuilder
extends EndpointAddressFluentImpl<EndpointAddressBuilder>
implements VisitableBuilder<EndpointAddress, EndpointAddressBuilder> {
    EndpointAddressFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointAddressBuilder() {
        this(true);
    }

    public EndpointAddressBuilder(Boolean validationEnabled) {
        this(new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance) {
        this(fluent, instance, true);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIp(instance.getIp());
        fluent.withTargetRef(instance.getTargetRef());
        this.validationEnabled = validationEnabled;
    }

    public EndpointAddressBuilder(EndpointAddress instance) {
        this(instance, (Boolean)true);
    }

    public EndpointAddressBuilder(EndpointAddress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIp(instance.getIp());
        this.withTargetRef(instance.getTargetRef());
        this.validationEnabled = validationEnabled;
    }

    public EndpointAddress build() {
        EndpointAddress buildable = new EndpointAddress(this.fluent.getIp(), this.fluent.getTargetRef());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointAddressBuilder that = (EndpointAddressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

