package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildStrategyAssert<S extends AbstractBuildStrategyAssert<S, A>, A extends BuildStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildStrategyAssert}</code> to make assertions on actual BuildStrategy.
   * @param actual the BuildStrategy we want to make assertions on.
   */
  protected AbstractBuildStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property customStrategy so that assertions can be done on it
   */
  public CustomBuildStrategyAssert customStrategy()  {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CustomBuildStrategyAssert) assertThat(actual.getCustomStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "customStrategy"));
  }


  /**
   * Navigates to the property dockerStrategy so that assertions can be done on it
   */
  public DockerBuildStrategyAssert dockerStrategy()  {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DockerBuildStrategyAssert) assertThat(actual.getDockerStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dockerStrategy"));
  }


  /**
   * Navigates to the property jenkinsPipelineStrategy so that assertions can be done on it
   */
  public JenkinsPipelineBuildStrategyAssert jenkinsPipelineStrategy()  {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JenkinsPipelineBuildStrategyAssert) assertThat(actual.getJenkinsPipelineStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jenkinsPipelineStrategy"));
  }


  /**
   * Navigates to the property sourceStrategy so that assertions can be done on it
   */
  public SourceBuildStrategyAssert sourceStrategy()  {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SourceBuildStrategyAssert) assertThat(actual.getSourceStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sourceStrategy"));
  }


  /**
   * Navigates to the property type so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert type()  {
    // check that actual BuildStrategy we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"));
  }


}
