/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LabelSelectorBuilder
extends LabelSelectorFluentImpl<LabelSelectorBuilder>
implements VisitableBuilder<LabelSelector, LabelSelectorBuilder> {
    LabelSelectorFluent<?> fluent;

    public LabelSelectorBuilder() {
        this(new LabelSelector());
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent) {
        this(fluent, new LabelSelector());
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, LabelSelector instance) {
        this.fluent = fluent;
        fluent.withMatchExpressions(instance.getMatchExpressions());
        fluent.withMatchLabels(instance.getMatchLabels());
    }

    public LabelSelectorBuilder(LabelSelector instance) {
        this.fluent = this;
        this.withMatchExpressions(instance.getMatchExpressions());
        this.withMatchLabels(instance.getMatchLabels());
    }

    public LabelSelector build() {
        LabelSelector buildable = new LabelSelector(this.fluent.getMatchExpressions(), this.fluent.getMatchLabels());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorBuilder that = (LabelSelectorBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

