/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressTLSFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressTLSBuilder
extends IngressTLSFluentImpl<IngressTLSBuilder>
implements VisitableBuilder<IngressTLS, IngressTLSBuilder> {
    IngressTLSFluent<?> fluent;

    public IngressTLSBuilder() {
        this(new IngressTLS());
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent) {
        this(fluent, new IngressTLS());
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent, IngressTLS instance) {
        this.fluent = fluent;
        fluent.withHosts(instance.getHosts());
        fluent.withSecretName(instance.getSecretName());
    }

    public IngressTLSBuilder(IngressTLS instance) {
        this.fluent = this;
        this.withHosts(instance.getHosts());
        this.withSecretName(instance.getSecretName());
    }

    public IngressTLS build() {
        IngressTLS buildable = new IngressTLS(this.fluent.getHosts(), this.fluent.getSecretName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressTLSBuilder that = (IngressTLSBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

