/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.APIVersion;
import io.fabric8.kubernetes.api.model.extensions.APIVersionFluent;
import io.fabric8.kubernetes.api.model.extensions.APIVersionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class APIVersionBuilder
extends APIVersionFluentImpl<APIVersionBuilder>
implements VisitableBuilder<APIVersion, APIVersionBuilder> {
    APIVersionFluent<?> fluent;

    public APIVersionBuilder() {
        this(new APIVersion());
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent) {
        this(fluent, new APIVersion());
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent, APIVersion instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
    }

    public APIVersionBuilder(APIVersion instance) {
        this.fluent = this;
        this.withName(instance.getName());
    }

    public APIVersion build() {
        APIVersion buildable = new APIVersion(this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIVersionBuilder that = (APIVersionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

