/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.NodeSpecFluent;
import io.fabric8.kubernetes.api.model.NodeSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeSpecBuilder
extends NodeSpecFluentImpl<NodeSpecBuilder>
implements VisitableBuilder<NodeSpec, NodeSpecBuilder> {
    NodeSpecFluent<?> fluent;

    public NodeSpecBuilder() {
        this(new NodeSpec());
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent) {
        this(fluent, new NodeSpec());
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, NodeSpec instance) {
        this.fluent = fluent;
        fluent.withExternalID(instance.getExternalID());
        fluent.withPodCIDR(instance.getPodCIDR());
        fluent.withProviderID(instance.getProviderID());
        fluent.withUnschedulable(instance.getUnschedulable());
    }

    public NodeSpecBuilder(NodeSpec instance) {
        this.fluent = this;
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withProviderID(instance.getProviderID());
        this.withUnschedulable(instance.getUnschedulable());
    }

    public NodeSpec build() {
        NodeSpec buildable = new NodeSpec(this.fluent.getExternalID(), this.fluent.getPodCIDR(), this.fluent.getProviderID(), this.fluent.isUnschedulable());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSpecBuilder that = (NodeSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

