/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeAddressFluent;
import io.fabric8.kubernetes.api.model.NodeAddressFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeAddressBuilder
extends NodeAddressFluentImpl<NodeAddressBuilder>
implements VisitableBuilder<NodeAddress, NodeAddressBuilder> {
    NodeAddressFluent<?> fluent;

    public NodeAddressBuilder() {
        this(new NodeAddress());
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent) {
        this(fluent, new NodeAddress());
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withType(instance.getType());
    }

    public NodeAddressBuilder(NodeAddress instance) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withType(instance.getType());
    }

    public NodeAddress build() {
        NodeAddress buildable = new NodeAddress(this.fluent.getAddress(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAddressBuilder that = (NodeAddressBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

