/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HostPathVolumeSourceBuilder
extends HostPathVolumeSourceFluentImpl<HostPathVolumeSourceBuilder>
implements VisitableBuilder<HostPathVolumeSource, HostPathVolumeSourceBuilder> {
    HostPathVolumeSourceFluent<?> fluent;

    public HostPathVolumeSourceBuilder() {
        this(new HostPathVolumeSource());
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSourceFluent<?> fluent) {
        this(fluent, new HostPathVolumeSource());
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSourceFluent<?> fluent, HostPathVolumeSource instance) {
        this.fluent = fluent;
        fluent.withPath(instance.getPath());
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSource instance) {
        this.fluent = this;
        this.withPath(instance.getPath());
    }

    public HostPathVolumeSource build() {
        HostPathVolumeSource buildable = new HostPathVolumeSource(this.fluent.getPath());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostPathVolumeSourceBuilder that = (HostPathVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

