/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluent;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildPostCommitSpecBuilder
extends BuildPostCommitSpecFluentImpl<BuildPostCommitSpecBuilder>
implements VisitableBuilder<BuildPostCommitSpec, BuildPostCommitSpecBuilder> {
    BuildPostCommitSpecFluent<?> fluent;

    public BuildPostCommitSpecBuilder() {
        this(new BuildPostCommitSpec());
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpecFluent<?> fluent) {
        this(fluent, new BuildPostCommitSpec());
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpecFluent<?> fluent, BuildPostCommitSpec instance) {
        this.fluent = fluent;
        fluent.withArgs(instance.getArgs());
        fluent.withCommand(instance.getCommand());
        fluent.withScript(instance.getScript());
    }

    public BuildPostCommitSpecBuilder(BuildPostCommitSpec instance) {
        this.fluent = this;
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withScript(instance.getScript());
    }

    public BuildPostCommitSpec build() {
        BuildPostCommitSpec buildable = new BuildPostCommitSpec(this.fluent.getArgs(), this.fluent.getCommand(), this.fluent.getScript());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildPostCommitSpecBuilder that = (BuildPostCommitSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

