/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildConfigSpecBuilder
extends BuildConfigSpecFluentImpl<BuildConfigSpecBuilder>
implements VisitableBuilder<BuildConfigSpec, BuildConfigSpecBuilder> {
    BuildConfigSpecFluent<?> fluent;

    public BuildConfigSpecBuilder() {
        this(new BuildConfigSpec());
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent) {
        this(fluent, new BuildConfigSpec());
    }

    public BuildConfigSpecBuilder(BuildConfigSpecFluent<?> fluent, BuildConfigSpec instance) {
        this.fluent = fluent;
        fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        fluent.withOutput(instance.getOutput());
        fluent.withPostCommit(instance.getPostCommit());
        fluent.withResources(instance.getResources());
        fluent.withRevision(instance.getRevision());
        fluent.withRunPolicy(instance.getRunPolicy());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withSource(instance.getSource());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTriggers(instance.getTriggers());
    }

    public BuildConfigSpecBuilder(BuildConfigSpec instance) {
        this.fluent = this;
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withRunPolicy(instance.getRunPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggers(instance.getTriggers());
    }

    public BuildConfigSpec build() {
        BuildConfigSpec buildable = new BuildConfigSpec(this.fluent.getCompletionDeadlineSeconds(), this.fluent.getOutput(), this.fluent.getPostCommit(), this.fluent.getResources(), this.fluent.getRevision(), this.fluent.getRunPolicy(), this.fluent.getServiceAccount(), this.fluent.getSource(), this.fluent.getStrategy(), this.fluent.getTriggers());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigSpecBuilder that = (BuildConfigSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

