/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodSecurityContextBuilder
extends PodSecurityContextFluentImpl<PodSecurityContextBuilder>
implements VisitableBuilder<PodSecurityContext, PodSecurityContextBuilder> {
    PodSecurityContextFluent<?> fluent;

    public PodSecurityContextBuilder() {
        this(new PodSecurityContext());
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent) {
        this(fluent, new PodSecurityContext());
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance) {
        this.fluent = fluent;
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
    }

    public PodSecurityContextBuilder(PodSecurityContext instance) {
        this.fluent = this;
        this.withFsGroup(instance.getFsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSupplementalGroups(instance.getSupplementalGroups());
    }

    public PodSecurityContext build() {
        PodSecurityContext buildable = new PodSecurityContext(this.fluent.getFsGroup(), this.fluent.isRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions(), this.fluent.getSupplementalGroups());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityContextBuilder that = (PodSecurityContextBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

