/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluent;
import io.fabric8.kubernetes.api.model.ContainerStateRunningFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateRunningBuilder
extends ContainerStateRunningFluentImpl<ContainerStateRunningBuilder>
implements VisitableBuilder<ContainerStateRunning, ContainerStateRunningBuilder> {
    ContainerStateRunningFluent<?> fluent;

    public ContainerStateRunningBuilder() {
        this(new ContainerStateRunning());
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent) {
        this(fluent, new ContainerStateRunning());
    }

    public ContainerStateRunningBuilder(ContainerStateRunningFluent<?> fluent, ContainerStateRunning instance) {
        this.fluent = fluent;
        fluent.withStartedAt(instance.getStartedAt());
    }

    public ContainerStateRunningBuilder(ContainerStateRunning instance) {
        this.fluent = this;
        this.withStartedAt(instance.getStartedAt());
    }

    public ContainerStateRunning build() {
        ContainerStateRunning buildable = new ContainerStateRunning(this.fluent.getStartedAt());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateRunningBuilder that = (ContainerStateRunningBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

